---
title: Overview · Cloudflare Magic WAN docs
description: Magic WAN provides secure, performant connectivity and routing for
  your entire corporate networking, reducing cost and operation complexity.
  Magic Firewall integrates smoothly with Magic WAN, enabling you to enforce
  network firewall policies at Cloudflare's global network, across traffic from
  any entity within your network.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/
  md: https://developers.cloudflare.com/magic-wan/index.md
---

Improve security and performance for your entire corporate networking, reducing cost and operation complexity.

Enterprise-only

Magic WAN provides secure, performant connectivity and [routing](https://www.cloudflare.com/learning/network-layer/what-is-routing/) for your entire corporate networking, reducing cost and operation complexity. [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) integrates smoothly with Magic WAN, enabling you to enforce network firewall policies at Cloudflare's global network, across traffic from any entity within your network.

With Magic WAN, you can securely connect any traffic source - data centers, offices, devices, cloud properties - to Cloudflare's network and configure routing policies to get the bits where they need to go, all within one SaaS solution.

Magic WAN supports a variety of on-ramps including any device that supports anycast GRE or IPsec tunnels. To make it easier to onboard your cloud properties, you can use [Magic Cloud Networking](https://developers.cloudflare.com/magic-wan/configuration/magic-cloud-networking/), which automates the process of creating on-ramps from your cloud networks.

Refer to [On-ramps](https://developers.cloudflare.com/magic-wan/on-ramps/) for a full list of supported on-ramps.

Learn how to [get started](https://developers.cloudflare.com/magic-wan/get-started/).

***

## Features

### Connect your network automatically

Use Magic WAN Connector to automatically connect, steer, and shape any IP traffic.

[Use Magic WAN Connector](https://developers.cloudflare.com/magic-wan/configuration/connector/)

### Connect your network manually

Magic WAN is compatible with a host of third-party devices. If you do not have Magic WAN Connector, start here to learn how to set up Magic WAN manually.

[Use a third-party device](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/)

### Automatic cloud on-ramps

Automate resource discovery, and reduce management burden when connecting to your public cloud.

[Automate your cloud on-ramps](https://developers.cloudflare.com/magic-wan/configuration/magic-cloud-networking/)

### Zero Trust integration

Learn how you can use Magic WAN with other Cloudflare Zero Trust products.

[Integrate with other Zero Trust products](https://developers.cloudflare.com/magic-wan/zero-trust/)

### BGP peering

Use BGP peering between your networks and Cloudflare to automate the process of adding or removing networks and subnets, and take advantage of failure detection and session recovery features.

[Use BGP peering](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/#configure-bgp-routes)

***

## Related products

**[Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/)&#x20;**&#x43;loudflare Zero Trust replaces legacy security perimeters with our global edge, making the Internet faster and safer for teams around the world.

**[Magic Firewall](https://developers.cloudflare.com/magic-firewall/)**

Magic Firewall is a firewall-as-a-service (FWaaS) delivered from the Cloudflare global network to protect office networks and cloud infrastructure with advanced, and scalable protection.

**[Magic Cloud Networking](https://developers.cloudflare.com/magic-cloud-networking/)&#x20;**&#x53;implify and automate cloud resource discovery, and reduce your management burden when connecting to your public cloud.

**[Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/)**

Cloudflare Network Interconnect (CNI) allows you to connect your network infrastructure directly with Cloudflare - rather than using the public Internet - for a more reliable and secure experience.

**[Load Balancing](https://developers.cloudflare.com/load-balancing/)**

Cloudflare Load Balancing distributes traffic across your endpoints, which reduces endpoint strain and latency and improves the experience for end users.

***

## More resources

[Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/sase/)

Deep dive into key architecture and functionalities aspects of Cloudflare One, and learn more about Magic WAN and its structure.
