---
title: Manage creators · Cloudflare Stream docs
description: You can set the creator field with an internal user ID at the time
  a tokenized upload URL is requested. When the video is uploaded, the creator
  property is automatically set to the internal user ID which can be used for
  analytics data or when searching for videos by a specific creator.
lastUpdated: 2024-09-24T15:46:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/stream/manage-video-library/creator-id/
  md: https://developers.cloudflare.com/stream/manage-video-library/creator-id/index.md
---

You can set the creator field with an internal user ID at the time a tokenized upload URL is requested. When the video is uploaded, the creator property is automatically set to the internal user ID which can be used for analytics data or when searching for videos by a specific creator.

For basic uploads, you will need to add the Creator ID after you upload the video.

## Upload from URL

```bash
curl "https://api.cloudflare.com/client/v4/accounts/{account_id}/stream/copy" \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data '{"url":"https://example.com/myvideo.mp4","creator": "<CREATOR_ID>","thumbnailTimestampPct":0.529241,"allowedOrigins":["example.com"],"requireSignedURLs":true,"watermark":{"uid":"ea95132c15732412d22c1476fa83f27a"}}'
```

**Response**

```json
{
  "success": true,
  "errors": [],
  "messages": [],
  "result": {
    "allowedOrigins": ["example.com"],
    "created": "2014-01-02T02:20:00Z",
    "duration": 300,
    "input": {
      "height": 1080,
      "width": 1920
    },
    "maxDurationSeconds": 300,
    "meta": {},
    "modified": "2014-01-02T02:20:00Z",
    "uploadExpiry": "2014-01-02T02:20:00Z",
    "playback": {
      "hls": "https://customer-f33zs165nr7gyfy4.cloudflarestream.com/6b9e68b07dfee8cc2d116e4c51d6a957/manifest/video.m3u8",
      "dash": "https://customer-f33zs165nr7gyfy4.cloudflarestream.com/6b9e68b07dfee8cc2d116e4c51d6a957/manifest/video.mpd"
    },
    "preview": "https://customer-f33zs165nr7gyfy4.cloudflarestream.com/6b9e68b07dfee8cc2d116e4c51d6a957/watch",
    "readyToStream": true,
    "requireSignedURLs": true,
    "size": 4190963,
    "status": {
      "state": "ready",
      "pctComplete": "100.000000",
      "errorReasonCode": "",
      "errorReasonText": ""
    },
    "thumbnail": "https://customer-f33zs165nr7gyfy4.cloudflarestream.com/6b9e68b07dfee8cc2d116e4c51d6a957/thumbnails/thumbnail.jpg",
    "thumbnailTimestampPct": 0.529241,
    "creator": "<CREATOR_ID>",
    "uid": "6b9e68b07dfee8cc2d116e4c51d6a957",
    "liveInput": "fc0a8dc887b16759bfd9ad922230a014",
    "uploaded": "2014-01-02T02:20:00Z",
    "watermark": {
      "uid": "6b9e68b07dfee8cc2d116e4c51d6a957",
      "size": 29472,
      "height": 600,
      "width": 400,
      "created": "2014-01-02T02:20:00Z",
      "downloadedFrom": "https://company.com/logo.png",
      "name": "Marketing Videos",
      "opacity": 0.75,
      "padding": 0.1,
      "scale": 0.1,
      "position": "center"
    }
  }
}
```

## Set default creators for videos

You can associate videos with a single creator by setting a default creator ID value, which you can later use for searching for videos by creator ID or for analytics data.

```bash
curl "https://api.cloudflare.com/client/v4/accounts/{account_id}/stream/live_inputs" \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data '{"DefaultCreator":"1234"}'
```

If you have multiple creators who start live streams, [create a live input](https://developers.cloudflare.com/stream/get-started/#step-1-create-a-live-input) for each creator who will live stream and then set a `DefaultCreator` value per input. Setting the default creator ID for each input ensures that any recorded videos streamed from the creator's input will inherit the `DefaultCreator` value.

At this time, you can only manage the default creator ID values via the API.

## Update creator in existing videos

To update the creator property in existing videos, make a `POST` request to the video object endpoint with a JSON payload specifying the creator property as show in the example below.

```bash
curl "https://api.cloudflare.com/client/v4/accounts/{account_id}/stream/<VIDEO_UID>" \
--header "Authorization: Bearer <AUTH_TOKEN>" \
--header "Content-Type: application/json" \
--data '{"creator":"test123"}'
```

## Direct creator upload

```bash
curl "https://api.cloudflare.com/client/v4/accounts/{account_id}/stream/direct_upload" \
--header "Authorization: Bearer <AUTH_TOKEN>" \
--header "Content-Type: application/json" \
--data '{"maxDurationSeconds":300,"expiry":"2021-01-02T02:20:00Z","creator": "<CREATOR_ID>", "thumbnailTimestampPct":0.529241,"allowedOrigins":["example.com"],"requireSignedURLs":true,"watermark":{"uid":"ea95132c15732412d22c1476fa83f27a"}}'
```

**Response**

```json
{
  "success": true,
  "errors": [],
  "messages": [],
  "result": {
    "uploadURL": "www.example.com/samplepath",
    "uid": "ea95132c15732412d22c1476fa83f27a",
    "creator": "<CREATOR_ID>",
    "watermark": {
      "uid": "ea95132c15732412d22c1476fa83f27a",
      "size": 29472,
      "height": 600,
      "width": 400,
      "created": "2014-01-02T02:20:00Z",
      "downloadedFrom": "https://company.com/logo.png",
      "name": "Marketing Videos",
      "opacity": 0.75,
      "padding": 0.1,
      "scale": 0.1,
      "position": "center"
    }
  }
}
```

## Get videos by Creator ID

```bash
curl "https://api.cloudflare.com/client/v4/accounts/{account_id}/stream?after=2014-01-02T02:20:00Z&before=2014-01-02T02:20:00Z&include_counts=false&creator=<CREATOR_ID>&limit=undefined&asc=false&status=downloading,queued,inprogress,ready,error" \
--header "Authorization: Bearer <API_TOKEN>"
```

**Response**

```json
{
  "success": true,
  "errors": [],
  "messages": [],
  "result": [
    {
      "allowedOrigins": ["example.com"],
      "created": "2014-01-02T02:20:00Z",
      "duration": 300,
      "input": {
        "height": 1080,
        "width": 1920
      },
      "maxDurationSeconds": 300,
      "meta": {},
      "modified": "2014-01-02T02:20:00Z",
      "uploadExpiry": "2014-01-02T02:20:00Z",
      "playback": {
        "hls": "https://customer-<CODE>.cloudflarestream.com/ea95132c15732412d22c1476fa83f27a/manifest/video.m3u8",
        "dash": "https://customer-<CODE>.cloudflarestream.com/ea95132c15732412d22c1476fa83f27a/manifest/video.mpd"
      },
      "preview": "https://customer-<CODE>.cloudflarestream.com/ea95132c15732412d22c1476fa83f27a/watch",
      "readyToStream": true,
      "requireSignedURLs": true,
      "size": 4190963,
      "status": {
        "state": "ready",
        "pctComplete": "100.000000",
        "errorReasonCode": "",
        "errorReasonText": ""
      },
      "thumbnail": "https://customer-<CODE>.cloudflarestream.com/ea95132c15732412d22c1476fa83f27a/thumbnails/thumbnail.jpg",
      "thumbnailTimestampPct": 0.529241,
      "creator": "some-creator-id",
      "uid": "ea95132c15732412d22c1476fa83f27a",
      "liveInput": "fc0a8dc887b16759bfd9ad922230a014",
      "uploaded": "2014-01-02T02:20:00Z",
      "watermark": {
        "uid": "ea95132c15732412d22c1476fa83f27a",
        "size": 29472,
        "height": 600,
        "width": 400,
        "created": "2014-01-02T02:20:00Z",
        "downloadedFrom": "https://company.com/logo.png",
        "name": "Marketing Videos",
        "opacity": 0.75,
        "padding": 0.1,
        "scale": 0.1,
        "position": "center"
      }
    }
  ],
  "total": "35586",
  "range": "1000"
}
```

## tus

Add the Creator ID via the `Upload-Creator` header. For more information, refer to [Resumable and large files (tus)](https://developers.cloudflare.com/stream/uploading-videos/resumable-uploads/#set-creator-property).

## Query by Creator ID with GraphQL

After you set the creator property, you can use the [GraphQL API](https://developers.cloudflare.com/analytics/graphql-api/) to filter by a specific creator. Refer to [Fetching bulk analytics](https://developers.cloudflare.com/stream/getting-analytics/fetching-bulk-analytics) for more information about available metrics and filters.
